##################################################################
# R code: Exercise 4.5 
# File: exercise45.r
#
# Coded by: Arthur Berg
#
# Note: Added to the R-code in the file "Exercise44.r" are the  
#       following three functions:
#          dataWN
#          dataWNchi
#          databil
##################################################################
# Trapezoid-shaped lag window
  trap <- function(x,M_spec,cef=.5){1/(1-cef)*max(0,1-abs(x)/   
  M_spec)-cef/(1-cef)*max(0,1-abs(x)/(cef*M_spec))}

# Trapezoid density function
trap_density <- function(w,Data,M_spec,cef=.5){
  trap <- function(x,M_spec,cef=.5){1/(1-cef)*max(0,1-abs(x)/
  M_spec)-cef/(1-cef)*max(0,1-abs(x)/(cef*M_spec))}
  sum <- 0
  for(s in (-M_spec):M_spec){
     sum<-sum+trap(s,M_spec,cef)*R(s,Data)*exp(-1i*s*w)}
     abs(sum/(2*pi))}

# Normalized bispectrum
norm.bispec <- function(w1,w2,Data,M_bispec,M_spec,cef=.5){
  n   <- length(Data)
  tmp <- (abs(rpf_density(w1,w2,Data,M_bispec,cef))^2*2*pi*n)/
  (M_bispec^2*1.375*trap_density(w1,Data,M_spec,cef)*
  trap_density(w2,Data,M_spec,cef)*
  trap_density(w1+w2,Data,M_spec,cef))
return(tmp)
}

# Sample ACVF
R<-function(lag,Data){     
  Xbar   <- mean(Data)
  n      <- length(Data)
  sumvar <- 0
  t      <- 1:(n-abs(lag))
  sum((Data[t]-Xbar)*(Data[t+abs(lag)]-Xbar))/(n)
}

# Third-order cumulant
Cfun<-function(t1,t2,Data){  
  n    <- length(Data)
  Xbar <- mean(Data)
  maxt <- max(0,t1,t2)
  mint <- min(0,t1,t2)
  t    <- 1:(n-maxt+mint)
  sum(
    (Data[t-mint]-Xbar)*(Data[t+t1-mint]-Xbar)*
    (Data[t+t2-mint]-Xbar))/(n-maxt+mint)
}

# Right-pyramidal frustum-shaped lag function
rpf_density <- function(w1,w2,Data,M_bispec,cef=.5){
  rp <- function(x,y){ifelse(abs(x)<=1 && abs(y)<=1 && sign(x)==
  sign(y),pmax(0,1-pmax(abs(x),abs(y))),pmax(0,1-pmax(abs(x+y),
  abs(x-y))))}
  rpf <- function(x,y,M_bispec,cef=.5){1/(1-cef)*rp(x/M_bispec,y/
  M_bispec)-cef/(1-cef)*rp(x/(cef*M_bispec),y/(cef*M_bispec))}
  Cdata  <- function(Data, win=win){
  C_data <- matrix(0,2*win+1,2*win+1)
  for(i in (-win):win){
    for(j in (-win):win){
      if(0<=j && j<=i){
      C_data[i+win+1,j+win+1]    <- Cfun(i,j,Data)
      C_data[j+win+1,i+win+1]    <- C_data[i+win+1,j+win+1]
      C_data[-i+win+1,j-i+win+1] <- C_data[i+win+1,j+win+1]
      C_data[i-j+win+1,-j+win+1] <- C_data[i+win+1,j+win+1]
      C_data[j-i+win+1,-i+win+1] <- C_data[i+win+1,j+win+1]
      C_data[-j+win+1,i-j+win+1] <- C_data[i+win+1,j+win+1]
    }
}}
C_data
}
win    <- M_bispec
C_data <- Cdata(Data,win=win)
sumvar <- 0
for(t1 in (-(M_bispec-1)):(M_bispec-1)){
   for(t2 in (-(M_bispec-1)):(M_bispec-1)){
       sumvar <- sumvar+rpf(t1,t2,M_bispec,cef)*
       C_data[win+1+t1,win+1+t2]*exp(-1i*t1*w1-1i*t2*w2)}}
return(1/(2*pi)^2*sumvar)
}

Hinich.test <- function(Data,N,M_bispec,M_spec,cef=.5){
  pts <- function(N){
    rh <- function(j){
       2*pi/3-2*pi*j/(3*(N+1))-.5/N
    }
    xp <- function(j){
      (2*pi-3*rh(j))/(2*(j+1))*(1:j)+rh(j)
    }
    tmp <- sapply(1:N,xp)
    xs  <- unlist(tmp)
    ys  <- rh(rep(1:N,1:N))
    pts <- list(xs=xs,ys=ys)
    return(pts) 
  }
  xy   <- pts(N)
  zs   <- norm.bispec(xy$xs,xy$ys,Data,M_bispec,M_spec,cef)
  T_G  <- sum(zs)
  k    <- choose(N+1,2)
  p_G  <- 1-pchisq(T_G,2*k)
  T_L  <- IQR(zs)
  n    <- length(Data)
  lam0 <- n*Cfun(0,0,Data)^2/(M_bispec^2*1.375*R(0,Data)^3)
  q3   <- qchisq(.75,2,lam0)  # quantile function, IQR
  q1   <- qchisq(.25,2,lam0)
  mu   <- q3-q1
  variance <- (3/dchisq(q3,2,lam0)^2+3/dchisq(q1,2,lam0)^2-2/
  (dchisq(q3,2,lam0)*dchisq(q1,2,lam0)))/(16*k) 
  sig      <- sqrt(variance)  # Estimate of sigma_{0} 
  p_L      <- 1-pnorm(T_L,mu,sig)
  z        <- list(T_G=T_G,p_G=p_G,T_L=T_L,p_L=p_L) 
  class(z) <- "Hinich.test"
  cl       <- match.call()
  z$call   <- cl
  z
}

print.Hinich.test <- function(object){
  z <- object
  cat("\nCall:\n",deparse(z$call,width=500),"\n\n",sep = "")
  cat("Gaussianity Test","\n")
  cat("----------------","\n")
  cat("test statistic: ", z$T_G, "\n")
  cat("p-value: ", z$p_G,"\n","\n")
  cat("Linearity Test","\n")
  cat("--------------","\n")
  cat("test statistic: ", z$T_L, "\n")
  cat("p-value: ", z$p_L,"\n","\n")   
}

boot.test <- function(bootnum,Data,ar_order,N,M_bispec,M_spec,
    cef=.5){
    fit     <- ar(Data,FALSE,ar_order) # Default is Yule-Walker
    ar.coef <- fit$ar
    res     <- fit$res[-(1:ar_order)]
    centered.res <- res-mean(res)
    sd.res  <- sd(res)
    boot.linear <- function(){
       s     <- sample(centered.res,replace=T)
       bootL <- filter(s,ar.coef,method="recursive")
       return(bootL)
    }
    boot.normal <- function(){
       s     <- rnorm(length(res),0,sd.res)
       bootG <- filter(s,ar.coef,method="recursive")
       return(bootG)
    }
    boot.symmetric <- function(){
       s     <- abs(sample(res,replace=T))*rbinom(length(res),1,.5)
       bootG <- filter(s,ar.coef,method="recursive")
    return(bootS)
    }
    T_Gs <- double(bootnum)
    T_Ls <- double(bootnum)
    for(i in 1:bootnum){
      bootL   <- boot.linear()
      testL   <- Hinich.test(bootL,N,M_bispec,M_spec,cef)
      T_Ls[i] <- testL$T_L
      bootG   <- boot.normal()
      testG   <- Hinich.test(bootG,N,M_bispec,M_spec,cef)
      T_Gs[i] <- testG$T_G
    }
    orig.test <- Hinich.test(Data,N,M_bispec,M_spec,cef)
    orig.test
    T_G      <- orig.test$T_G
    T_L      <- orig.test$T_L
    boot.p_G <- 1-ecdf(T_Gs)(T_G)
    boot.p_L <- 1-ecdf(T_Ls)(T_L)
    z        <- list(boot.p_G=boot.p_G,boot.p_L=boot.p_L)
    class(z) <- "boot.test"
    cl       <- match.call()
    z$call   <- cl
    z$T_Gs   <- T_Gs
    z$T_Ls   <- T_Ls
    z$T_G    <- T_G
    z$T_L    <- T_L
    z
}

print.boot.test <- function(object){
  z <- object
  cat("\nCall:\n", deparse(z$call,width=500),"\n\n",sep="")
  cat("Bootstrapped Gaussianity Test","\n")
  cat("----------------","\n")
  cat("p-value: ", z$boot.p_G,"\n","\n")
  cat("Bootstrapped Linearity Test","\n")
  cat("--------------","\n")
  cat("p-value: ", z$boot.p_L,"\n","\n")
}

dataWN<-function(n){
  m     <- 1000
  b     <- 0
  evars <- rnorm(n+m,0,1)
  Data  <- rep(b/(1),n+m)   # starts with 0
  for(j in 2:(n+m)){Data[j]<- evars[j]}
    data <- Data[-(1:m)]
  }

dataWNchi <- function(n){
  m     <- 1000
  b     <- 0
  evars <- rnorm(n+m,0,1)^2
  Data  <- rep(b/(1),n+m)   # starts with 0
  for(j in 2:(n+m)){Data[j]<- evars[j]}
    data <- Data[-(1:m)]
}

databil <- function(n){
  b     <- 0.4                  # Parameter value BL process
  m     <- 1000
  evars <- rnorm(n+m,0,1)
  Data  <- rep(b/(1),n+m)   # starts with 0
  for(j in 2:(n+m)){Data[j]<-b*Data[j-1]*evars[j-1]+evars[j]}
    data <- Data[-(1:m)]
} 

